/**********************************************************************************************
* Device      : AD18F08
* Author      : fengxuanmian
* Version     : V0.0.1
* Date        : 2023.5.5
* Description : 主函数调用嵌套的子函数，导致出现堆栈溢出。当选择禁止堆栈溢出复位时，PB4出现翻转；当选择使能堆栈溢出复位时，芯片会不断复位 PB4翻转断断续续；
***********************************************************************************************/

#include "AD18F08.h"
#include <stdio.h>

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_OFF         :  禁止LVR
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	       	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF		    :  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON		    :  ADC采集速度选择位
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_OFF_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );
//---------配置字 STV 可选--------------
//_STV_OFF_2L       禁止堆栈溢出复位
//_STV_ON_2L        使能堆栈溢出复位
//------------------------

unsigned  char  call0(void);
unsigned  char  call1(void);
unsigned  char  call2(void);
unsigned  char  call3(void);
unsigned  char  call4(void);
unsigned  char  call5(void);
unsigned  char  call6(void);
unsigned  char  call7(void);
unsigned  char  call8(void);
unsigned  char  call9(void);

unsigned char call0(void) @0x0100
{
    unsigned char i ;
	i= call1();
	return i;

}

unsigned char call1(void) @0x0200
{
    unsigned char i ;
	i= call2();
	return i;

}

unsigned char call2(void) @0x0300
{
    unsigned char i ;
	i= call3();
	return i;

}

unsigned char call3(void) @0x0400
{
    unsigned char i ;
	i= call4();
	return i;

}

unsigned char call4(void) @0x0500
{
    unsigned char i ;
	i= call5();
	return i;

}

unsigned char call5(void) @0x0600
{
    unsigned char i ;
	i= call6();
	return i;

}

unsigned char call6(void) @0x0700
{
    unsigned char i ;
	i= call7();
	return i;

}

unsigned char call7(void) @0x0800
{
    unsigned char i ;
	i= call8();
	return i;

}

unsigned char call8(void) @0x0900
{

	return 8;
}

void main (void)
{
    unsigned char tmp = 0;
    TRISB4  = 0 ;     //PB4设置为输出
    CKOE0 = 1 ;       //PB4输出当前系统时钟

    tmp = call0();
	while(1)
	{

	}
}


//高优先级中断服务函数
void interrupt ISR_h (void)
{

}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{

}

